require("camerashake")


FollowCamera = Class(function(self, inst)
    self.inst = inst
    self.target = nil
    self.currentpos = Vector3(0,0,0)
	self.distance = 30
    self:SetDefault()
    self:Snap()
    self.time_since_zoom = nil
end)

function FollowCamera:SetDefault()
    self.targetpos = Vector3(0,0,0)
    --self.currentpos = Vector3(0,0,0)
    self.targetoffset = Vector3(0,1.5,0)

    if self.headingtarget == nil then
        self.headingtarget = 45
    end

    self.fov = 35
    self.pangain = 4
    self.headinggain = 20
    self.distancegain = 1

    self.zoomstep = 4
    self.distancetarget = 30

    self.mindist = 15
    self.maxdist = 50 --40
   
    self.mindistpitch = 30
    self.maxdistpitch = 60--60 
    self.paused = false
    self.shake = nil
    self.controllable = true
    self.cutscene = false
	
	--FPS CHANGE 	-DECLARING THIS HERE
	self.pitch = 0
	self.slowturning = false --MOVING THE MOUSE DURING SLOWTURNS CANCELS THE SLUGGISH MOVEMENT
	self.boby = 0

    if GetWorld() and GetWorld():IsCave() then
        self.mindist = 15
        self.maxdist = 35
        self.mindistpitch = 25
        self.maxdistpitch = 40
        self.distancetarget = 25
    end

    if self.target then
        self:SetTarget(self.target)
    end
	
	--SINCE CERTAIN INTROS REMOVE OUR FIRST-PERSON VIEW AFTER SETTING DEFAULT, DOUBLE CHECK TO SEE IF WE SHOULD JUST GO TO FP INSTEAD
	-- GetPlayer():DoTaskInTime(0.5, function() 
		if (GetPlayer() and GetPlayer().FPSmode == true) and self.cutscene == false then --IF WE ARENT IN CUTSCENE ANYMORE
			self:SetFPSMode()
			print("PUT ME IN FPS MODE")
		end
	-- end)

end


local function normalize(angle)
    while angle > 360 do
        angle = angle - 360
    end
    while angle < 0 do
        angle = angle + 360
    end
    return angle
end







--1-19 -IS IT REALLY A GOOD IDEA TO JUST TAKE THE ENTIRE FOLLOWCAM.LUA FILE TO MAKE CHANGES??   
	--IT SURE ISN'T, BUT THAT'S NEVER STOPPED ME BEFORE

--FPS CHANGES
function FollowCamera:SetFPSMode()
    -- self.targetoffset = Vector3(0,1.0,0)
	self.targetoffset = Vector3(0,FPSCAMHEIGHT,0) --4-21-18 ADDING HEIGHT ADJUSTER
	self.distance = 5
	
	self.fov = FPSFOV --70 --35 --FPS --REUSEABLE
    self.pangain = 50 --4
    self.headinggain = 50 --20
    self.distancegain = 20 --1
	
	self.distancetarget = 0.5 --.5 --15
	self.pitch = 0 --LOOK STRAIGHT AHEAD

	self.mindist = 0 --0
    self.maxdist = 45 --40
	
	--SHIPWRECKED DS CHANGE -- IF WE'RE ON A BOAT WHEN WE RETURN TO FP VIEW, SNAP TO BOAT MODE
	if GetPlayer() and GetPlayer():HasTag("aquatic") then
		self:SetSailorMode()
	end
end


function FollowCamera:SetRiderMode()
    self.targetoffset = Vector3(0,3,0)
	-- if GetPlayer().FPSmode then
	self.distancetarget = 0.5 --10 --15
	self.pitch = 0

	self.mindist = 0 --0
    self.maxdist = 45 --40
end


--SHIPWRECKED CHANGE
function FollowCamera:SetSailorMode()
    self.targetoffset = Vector3(0,1.3,0)
	-- self.distancegain = 1
	
	self.distancetarget = 0.2 --.5 --15
	-- self.pitch = 0 --LOOK STRAIGHT AHEAD

	self.mindist = 0 --0
    self.maxdist = 45 --40
end


--SHIPWRECKED DS CHANGE -- FOR WHEN YOUR SAIL/CANON IS EQUIPPED AND TAKES UP THE WHOLE DANG SCREEN
function FollowCamera:SetCameraLean(rightlean)
	--SHIPWRECKED DS CHANGE-
	-- print("RIGHT OFFSET ", self:GetRightVec())
	local sidelean = self:GetRightVec()
	local px = (sidelean.x) * rightlean
	local pz = (sidelean.z) * rightlean
	
	self.targetoffset = Vector3(px,1.3,pz)  --CAN WE JUST ASSUME Y WILL ALWAYS BE 1.3 BECAUSE ITS IN A BOAT?
end



--3-6-18
local function GetClosestHeading(lastheading)

	local roundedheading = 45
	
	if lastheading < 45 then
		roundedheading = 0
	elseif lastheading < 90 then
		roundedheading = 45
	elseif lastheading < 135 then
		roundedheading = 90
		
	elseif lastheading < 180 then
		roundedheading = 135
	elseif lastheading < 225 then
		roundedheading = 180
	elseif lastheading < 270 then
		roundedheading = 225
	elseif lastheading < 315 then
		roundedheading = 270
	elseif lastheading < 360 then
		roundedheading = 315
	else
		roundedheading = 0 --IF SOMETHING WEIRD HAPPENS
	end
	
	return roundedheading
end

function FollowCamera:SetNewDefault()
    -- self.targetoffset = Vector3(0,0,0)
	self.targetoffset = Vector3(0, 1.5, 0) --OH, I DIDN'T KNOW THIS WAS THE DEFAULT IN THIS GAME
	self.distance = 30
	 
	self.fov = 35
	self.pangain = 4
    self.headinggain = 20
    self.distancegain = 1
	 
	self.distancetarget = 30
	-- self.headingtarget = 45
	self.headingtarget = GetClosestHeading(self.headingtarget) --SET THE CAMERA BACK TO THE CLOSEST ANGLE TO THE ONE THE PLAYER WAS FACING

	self.mindist = 15
    self.maxdist = 50
   
    self.mindistpitch = 30
    self.maxdistpitch = 60
	   
		-- self.mindistpitch = 30
		-- self.maxdistpitch = 60--60 
		
	self.pitch = 60
end


--LET THE CAMERA MOVEMENTS TWEEN FOR A SEC INSTEAD OF JUST SNAPPING INSTANTLY INTO PLACE
function FollowCamera:EnableTempGains()
     self.distancegain = 1
	 self.headinggain = 5
	 self.pangain = 1
	  
	 GetPlayer():DoTaskInTime(1, function() 
		self.distancegain = 20 
		 self.headinggain = 50
		 self.pangain = 50
	end)
end


function FollowCamera:TempSlowTurn()
	 self.headinggain = 5
	 self.slowturning = true --SO MOVING THE MOUSE CANCELS THE SLUGGISH MOVEMENT
	  
	 GetPlayer():DoTaskInTime(0.5, function() 
		 self.headinggain = 50
	end)
end

function FollowCamera:CancelSlowTurn()
	if self.slowturning == true then
		self.headinggain = 50
		self.slowturning = false
	end
end


--MOSTLY FOR WOODIES TRANSFORMATION
function FollowCamera:TempTransformSpotlight()
	 self.distance = 5
	 self.pitch = 40
	 --NO MOVING!
	 self.distancegain = 0
	 self.headinggain = 0
	 self.pangain = 0
	 
	 --OR JUST THIS I GUESS
	 -- self:SetPaused(true)
	 
	 --OKAY, HOW ABOUT THIS?
	 GetPlayer().components.retmanager.mouselock = true
	  
	 GetPlayer():DoTaskInTime(1.5, function() 
		 self:SetFPSMode()
		 -- self:SetPaused(false)
		 GetPlayer().components.retmanager.mouselock = false
	end)
end



--FPS CHANGES
-- local bobpeak = 0.08
local bobarc = "up"
local bobspeed = 0.02
local bobspeedmult = 1


function FollowCamera:BobHead(direction, arcsize, speed) --dt
-- print("MY FRAME DT IS ", dt)
	
	if direction and direction == "down" then --IN OUR RUN_PST STATE, COME BACK DOWN
		bobarc = "down"
		if self.boby == 0 then 
			return
		elseif self.boby < 0 then --COME BACK DOWN TO 0, BUT DONT GO PAST IT
			self.boby = 0
			return
		end
	end
	
	local bobpeak = arcsize or 0.08
    
	if self.boby <= (bobpeak/3) then
		bobspeedmult = 1.2	--BOB A LITTLE FASTER NEAR THE BASE OF THE ARC
	elseif self.boby >= (bobpeak*2/3) then
		bobspeedmult = 0.5
	else
		bobspeedmult = 1
	end
	
	if speed then bobspeedmult = bobspeedmult*speed end --IF WE WERE GIVEN A SPEED OVERRIDE INPUT
	
	
	-- local bobpos = (bobspeed * bobspeedmult*(dt*30))
	local bobpos = (bobspeed * bobspeedmult)
	
	if bobarc == "up" then 
		self.boby = self.boby + bobpos
		if self.boby > bobpeak then
			bobarc = "down"
		end
		
	elseif bobarc == "down" then
		self.boby = self.boby - bobpos
		if self.boby < 0 then
			bobarc = "up"
		end
		
	end
	
	
	--OKAY, LETS PASS THIS FUNCTION ON TO OUR WEAPON MODEL.
	-- GetPlayer().HUD.controls.playermodel.bob --OKAY OR NOT
	local weaponmodel = GetPlayer().HUD.controls.playermodel
	-- class.playermodel:SetPosition(0,-350* (w/1366), 0)
	-- weaponmodel:SetPosition(0,-350* (RESOLUTION_X/1366) + (self.boby * (RESOLUTION_X/5) ), 0)
	-- local w,h = TheSim:GetScreenSize() --ALRIGHT ALRIGHT, FINE...
	local w = RESOLUTION_X * WEAPONMODELSIZE --NOT ANYMORE MY DUDES
	local h = RESOLUTION_Y * WEAPONMODELSIZE
	-- weaponmodel:SetPosition(0,-350 * (w/1366) + (self.boby * (h/5) ), 0) --WAIT, WHAT IS THIS???
	weaponmodel:SetPosition(0, (-350 * (w/1366)) + (self.boby * (h/5)), 0)
	
	
end











function FollowCamera:GetRightVec()
    return Vector3(math.cos((self.headingtarget + 90)*DEGREES), 0, math.sin((self.headingtarget+ 90)*DEGREES))
end

function FollowCamera:GetDownVec()
    return Vector3(math.cos((self.headingtarget)*DEGREES), 0, math.sin((self.headingtarget)*DEGREES))
end

function FollowCamera:SetPaused(val)
	self.paused = val
end

function FollowCamera:SetMinDistance(distance)
    self.mindist = distance
end

function FollowCamera:SetGains(pan, heading, distance)
    self.distancegain = distance
    self.pangain = pan
    self.headinggain = heading
end

function FollowCamera:IsControllable()
    return self.controllable
end

function FollowCamera:SetControllable(val)
    self.controllable = val
end

function FollowCamera:CanControl()
    -- return self.controllable
	if GetPlayer() and (GetPlayer().FPSmode == true) then --FPS CHANGE
		return false --HOLDQ IS WHEN THE PLAYER HAS JUST CLICKED TOGGLECAM BUT HASN'T LET GO OF Q YET
	else
		return self.controllable
	end
end

function FollowCamera:SetOffset(offset)
    self.targetoffset.x, self.targetoffset.y, self.targetoffset.z = offset.x, offset.y, offset.z
end

function FollowCamera:GetDistance()
    return self.distancetarget
end

function FollowCamera:SetDistance(dist)
    self.distancetarget = dist
end

function FollowCamera:Shake(type, duration, speed, scale)
    if Profile:IsScreenShakeEnabled() then
        self.shake = CameraShake(type, duration, speed, scale)
    end
    local shake_scale = math.max(0, math.min(scale/4, 1))
    TheInputProxy:AddVibration(VIBRATION_CAMERA_SHAKE, duration, shake_scale, false)    
end

function FollowCamera:SetTarget(inst)
    self.target = inst
    self.targetpos.x, self.targetpos.y, self.targetpos.z = self.target.Transform:GetWorldPosition()
    --self.currentpos.x, self.currentpos.y, self.currentpos.z = self.target.Transform:GetWorldPosition()
end

function FollowCamera:Apply()
    
    --dir
    local dx = -math.cos(self.pitch*DEGREES)*math.cos(self.heading*DEGREES)
    local dy = -math.sin(self.pitch*DEGREES)
    local dz = -math.cos(self.pitch*DEGREES)*math.sin(self.heading*DEGREES)
	
	
	--FPS CHANGE- AN EASIER WAY TO DETERMINE WHEN TO BOB THE CAMERA
	local bobmod = 0
	if self.bobhead_enabled then --ONLY APPLY BOB WHEN BOBHEAD IS SET TO TRUE
		bobmod = self.boby  --SO MANY BOBS...
	end

    --pos
    local px = dx*(-self.distance) + self.currentpos.x 
    local py = dy*(-self.distance) + self.currentpos.y 
    local pz = dz*(-self.distance) + self.currentpos.z 

    --right
    local rx = math.cos((self.heading+90)*DEGREES)
    local ry = 0
    local rz = math.sin((self.heading+90)*DEGREES)

    --up
    local ux, uy, uz =  dy * rz - dz * ry,
                        dz * rx - dx * rz,
                        dx * ry - dy * rx


	
    -- TheSim:SetCameraPos(px,py ,pz)
	TheSim:SetCameraPos(px, (py + (math.abs((self.pitch/90)/2)) + bobmod ) ,pz) --FPS CHANGE-
    TheSim:SetCameraDir(dx, dy, dz)
    TheSim:SetCameraUp(ux, uy, uz)
    TheSim:SetCameraFOV(self.fov)
    
    --local listenpos = dir*(-self.distance*.1) + self.currentpos

    --listen dist
    local lx = dx*(-self.distance*.1) + self.currentpos.x
    local ly = dy*(-self.distance*.1) + self.currentpos.y
    local lz = dz*(-self.distance*.1) + self.currentpos.z
	--print (lx, ly, lz, self.distance)
    TheSim:SetListener(lx, ly, lz, dx, dy, dz, ux, uy, uz)
    
end

-- local lerp = function(lower, upper, t)
   -- if t > 1 then t = 1 elseif t < 0 then t = 0 end
   -- return lower*(1-t)+upper*t 
-- end

local function lerp(lower, upper, t)
	return 
		t > 30 and upper --FPS CHANGE - THIS LINE IS ASSUMING FPS MODE IS TRUE, WE DONT WANT THE CAMERA SLIDING AROUND
		or t > 1 and upper
        or (t < 0 and lower
        or lower * (1 - t) + upper * t)
end

function FollowCamera:GetHeading()
    return self.heading
end
function FollowCamera:GetHeadingTarget()
    return self.headingtarget
end

function FollowCamera:SetHeadingTarget(r)
    self.headingtarget = r
end

function FollowCamera:ZoomIn()
    self.distancetarget = self.distancetarget - self.zoomstep
    if self.distancetarget < self.mindist then
        self.distancetarget = self.mindist
        
    end
    self.time_since_zoom = 0
    
end

function FollowCamera:ZoomOut()
    self.distancetarget = self.distancetarget + self.zoomstep
    if self.distancetarget > self.maxdist then
        self.distancetarget = self.maxdist
    end    
	self.time_since_zoom = 0	
end


--THROWN IN FOR SHIPWRECKED I GUESS
function FollowCamera:GetTimeSinceZoom()
    return self.time_since_zoom
end 


function FollowCamera:Snap()
    if self.target then
        self.targetpos = Vector3(self.target.Transform:GetWorldPosition()) + self.targetoffset
    else
        self.targetpos.x,self.targetpos.y,self.targetpos.z = self.targetoffset.x,self.targetoffset.y,self.targetoffset.z
    end

    self.currentpos.x, self.currentpos.y, self.currentpos.z = self.targetpos.x, self.targetpos.y, self.targetpos.z
    self.heading = self.headingtarget
    self.distance = self.distancetarget

    local percent_d = (self.distance - self.mindist)/ (self.maxdist - self.mindist)
    -- self.pitch = lerp(self.mindistpitch, self.maxdistpitch, percent_d)
	if GetPlayer() and GetPlayer().FPSmode == false then --FPS CHANGE - JUST ADDED THE LOGIC, NOT THE PITCH FORMULA
		self.pitch = lerp(self.mindistpitch, self.maxdistpitch, percent_d)
	end
    
    self:Apply()
end

function FollowCamera:CutsceneMode(b)
    self.cutscene = b
end

function FollowCamera:SetCustomLocation(loc)
    self.targetpos.x,self.targetpos.y,self.targetpos.z  = loc.x,loc.y,loc.z
end

function FollowCamera:Update(dt)

	if self.paused then
		return
	end

    if self.cutscene then

        self.currentpos.x = lerp(self.currentpos.x, self.targetpos.x + self.targetoffset.x, dt*self.pangain)
        self.currentpos.y = lerp(self.currentpos.y, self.targetpos.y + self.targetoffset.y, dt*self.pangain)
        self.currentpos.z = lerp(self.currentpos.z, self.targetpos.z + self.targetoffset.z, dt*self.pangain)


        if self.shake then
            local shakeOffset = self.shake:Update(dt)
            if shakeOffset then
                local upOffset = Vector3(0, shakeOffset.y, 0)
                local rightOffset = self:GetRightVec() * shakeOffset.x
                self.currentpos.x = self.currentpos.x + upOffset.x + rightOffset.x
                self.currentpos.y = self.currentpos.y + upOffset.y + rightOffset.y
                self.currentpos.z = self.currentpos.z + upOffset.z + rightOffset.z
            else
                self.shake = nil
            end
        end

        if math.abs(self.heading - self.headingtarget) > .01 then
            self.heading = lerp(self.heading, self.headingtarget, dt*self.headinggain)    
        end

        if math.abs(self.distance - self.distancetarget) > .01 then
            self.distance = lerp(self.distance, self.distancetarget, dt*self.distancegain)    
        end

        local percent_d = (self.distance - self.mindist)/ (self.maxdist - self.mindist)
        self.pitch = lerp(self.mindistpitch, self.maxdistpitch, percent_d)
		
		--IF WE TALKIN TO MAXWELL, CHECK TO SEE IF WE SHOULD GO BACK TO FPS MODE WHEN WE DONE
		-- GetPlayer():DoTaskInTime(0.5, function() 
			-- if (GetPlayer() and GetPlayer().FPSmode == true) and self.cutscene == false then --IF WE ARENT IN CUTSCENE ANYMORE
				-- self:SetFPSMode()
				-- print("PUT ME IN FPS MODE")
			-- end
		-- end)

    else
    	if self.time_since_zoom then
    		self.time_since_zoom = self.time_since_zoom + dt
    	
    		if self.should_push_down and self.time_since_zoom > .25 then
    			self.distancetarget = self.distance - self.zoomstep
    		end
    	end

        if self.target then
            --self.targetpos = Vector3(self.target.Transform:GetWorldPosition()) + self.targetoffset
            local x, y, z = self.target.Transform:GetWorldPosition()
            self.targetpos.x = x + self.targetoffset.x
            self.targetpos.y = y + self.targetoffset.y
            self.targetpos.z = z + self.targetoffset.z

        else
            self.targetpos.x, self.targetpos.y, self.targetpos.z = self.targetoffset.x, self.targetoffset.y, self.targetoffset.z
        end

        self.currentpos.x = lerp(self.currentpos.x, self.targetpos.x, dt*self.pangain)
        self.currentpos.y = lerp(self.currentpos.y, self.targetpos.y, dt*self.pangain)
        self.currentpos.z = lerp(self.currentpos.z, self.targetpos.z, dt*self.pangain)

        --self.currentpos = lerp(self.currentpos, self.targetpos, dt*self.pangain)
        
        if self.shake then
            local shakeOffset = self.shake:Update(dt)
            if shakeOffset then
                local upOffset = Vector3(0, shakeOffset.y, 0)
                local rightOffset = self:GetRightVec() * shakeOffset.x
                self.currentpos.x = self.currentpos.x + upOffset.x + rightOffset.x
                self.currentpos.y = self.currentpos.y + upOffset.y + rightOffset.y
                self.currentpos.z = self.currentpos.z + upOffset.z + rightOffset.z
            else
                self.shake = nil
            end
        end
		
		--ADDING THIS IN FROM THE DST VERSION
		self.heading = normalize(self.heading)
		self.headingtarget = normalize(self.headingtarget)
        
        if math.abs(self.heading - self.headingtarget) > .01 then
            self.heading = lerp(self.heading, self.headingtarget, dt*self.headinggain)    
        else
            self.heading = self.headingtarget
        end


        -- if math.abs(self.distance - self.distancetarget) > .01 then
            -- self.distance = lerp(self.distance, self.distancetarget, dt*self.distancegain)    
        -- else
            -- self.distance = self.distancetarget
        -- end
		--FPS - OKAY HERES A VERSION WITH THE IMPORTANT STUFF TACKED ON
		local pitchmod = math.clamp((1 - (self.pitch/90)/1), 0, 1)
		self.distance =
			math.abs(self.distance - self.distancetarget + pitchmod) > .01 and
			lerp(self.distance, self.distancetarget + pitchmod, dt * self.distancegain) or
			self.distancetarget + pitchmod
			
			
        
        local percent_d = (self.distance - self.mindist)/ (self.maxdist - self.mindist)
        -- self.pitch = lerp(self.mindistpitch, self.maxdistpitch, percent_d)
		if GetPlayer() and GetPlayer().FPSmode == false then --FPS CHANGE - JUST ADDED THE LOGIC, NOT THE PITCH FORMULA
			self.pitch = lerp(self.mindistpitch, self.maxdistpitch, percent_d)
		end
    end
    self:Apply()

    
end


return FollowCamera
